MODULE mGlobalData
implicit none

PUBLIC

    integer, parameter :: lunF1=100,lunF2=200,lunF3=300,lunF4=400,lunFScreen=500    !io-unit
    integer (kind=4), parameter :: sup0=0,sup1=1,sup2=2,sup3=3,sup4=4
    integer (kind=4), parameter :: sup5=5,sup6=6,sup7=7,sup8=8,sup9=9
    integer (kind=4) nOrder 
    integer (kind=4) kMaxEx,iterRE3D,iterDW1D,iterKFM,MaxIterKFM,MinIterKFM,MaxIterStartKFM,AddIter
    integer (kind=4) maxiter3D,maxiter3D_SS,resultsIter3D
    integer (kind=4) maxiter1D,maxiter1D_SS,resultsIter1D
    integer (kind=4) nWriteResults,icntTimeStep/0/
    integer (kind=4) norder_ex
    
    real (kind=8)  xvertex_ex,dx_ex,dlx1_ex,dlx2_ex    
    real (kind=8), parameter :: pi=4.d0*atan(1.d0), gravity=9.81d0
    real (kind=8), parameter :: eps_small=1d-12, eps_large=1d12
    real (kind=8) x1Matrix,x2Matrix,y1Matrix,y2Matrix,z1Matrix,z2Matrix
    real (kind=8) x1Conduit,x2Conduit,yConduit,zConduit
    real (kind=8) xPerforEnd,xPerforTrans
    real (kind=8) ConduitDiameter,ConduitRectangularWidth,ConduitRectangularTop
    !real (kind=8) PipeDiameter,PipeRough,PipePerfAreaPerc,KinematicViscosity
    real (kind=8) epsNonLinKFM,epsCurrKFM/0.d0/
    real (kind=8) TimeStart,TimeCurr,TimeStep,TimeEnd
    real (kind=8) MinTimeStep,MaxTimeStep
    real (kind=8) dt3D,dt1D
    real (kind=8) QmatrixInlet/0.d0/,QmatrixOutlet/0.d0/,Qrain/0.d0/
    real (kind=8) QconduitInlet/0.d0/,QconduitOutlet/0.d0/,Qsinkhole/0.d0/,QconduitXspec/0.d0/
    real (kind=8) HmatrixMax,HmatrixMin
    real (kind=8) DischargeUnitConvert,HeadUnitConvert,TimeUnitConvert
    real (kind=8) CpuTime
    real (kind=8) epsMatrix3D,CoeffEps3D/0.d0/,ValueEps3D/0.d0/
    real (kind=8) epsConduit1D,CoeffEps1D/0.d0/,ValueEps1D/0.d0/
    real (kind=8) epsCurr3D,epsCurr1D
    real (kind=8) IUR3D,EUR3D,epsUR3D
    real (kind=8) IUR1D,EUR1D,epsUR1D
    real (kind=8) FluxRelaxation3D,epsFR3D,cfFR3D,BCPenalty3D
    real (kind=8) SourceRelaxation1D,epsSR1D,cfSR1D,BCPenalty1D
    real (kind=8) PartOfConstantValue,cfSS3D,cfSS1D
    
    character (len=20) BasisFun,CorrectMaxIter
    character (len=20) ConduitCrossSection,ConduitPipe
    character (len=20) TestCase
    character (len=20) SteadyOrTransient3D,Symmetry3D,OppositeSignStabilization3D,DirichetBCImposition3D
    character (len=20) SteadyOrTransient1D,OppositeSignStabilization1D,DirichetBCImposition1D
    character (len=20) ScreenRecordFile/'ScreenRecord.dat'/
    
    logical MATRIX3D,CONDUIT1D
    logical UpStreamW_Ksat3D,UpStreamW_Krel3D,StronglyImposedDirichetBC3D,StronglyImposedDirichetBC1D
    logical MassLump3D,MassLump1D
    logical SteadyStateKFM/.false./
    logical ProceedToNextTimeStep/.true./
    
    !External functions
    real (kind=8),external:: HeadDifference    


    CONTAINS
    
!___________________________________________________________!
    
    subroutine InputData_KFM

        read(lunGid_dat,*) Title
        
        !Define problem - M+C; M; C.    true/false
        read(lunGid_dat,*) MATRIX3D, CONDUIT1D
        
!        MATRIX3D=.true.
!        CONDUIT1D=.true.
        
        !Matrix dimensions
!        x1Matrix=0.d0   ;   x2Matrix=4.d0   !4.d0
!        y1Matrix=0.d0   ;   y2Matrix=2.55d0 !2.4d0  !1.d0   !0.05d0   !2.5d0
!        z1Matrix=0.d0   ;   z2Matrix=2.d0  !2.d0
        
        read(lunGid_dat,*)x1Matrix=0.d0, x2Matrix=4.d0, y1Matrix=0.d0, y2Matrix, z1Matrix=0.d0, z2Matrix=2.d0
        
        !!Infiltrometer
        !x1Matrix=0.d0   ;   x2Matrix=0.0408d0
        !y1Matrix=0.d0   ;   y2Matrix=0.0408d0
        !z1Matrix=0.d0   ;   z2Matrix=0.2750d0
        !
        !!!DeRooij 5.3
        !!x1Matrix=0.d0   ;   x2Matrix=2.d0
        !!y1Matrix=0.d0   ;   y2Matrix=2.d0
        !!z1Matrix=0.d0   ;   z2Matrix=6.d0        
        
        !Experiment
        
        read(lunGid_dat,*) TestCase, ConduitPipe
        
!        TestCase='C3'    ! C2 C3    ; MA01-MA11 (MatrixAnisotropy) RI01 (RainInfiltration)   !In the article the conduits C3 and C1 have switched names
        
!        ConduitPipe='C3'
!        if(TestCase.eq.'C3') ConduitPipe='C3'
!        if(TestCase.eq.'C2') ConduitPipe='C2'
!        if(TestCase.eq.'MA07') ConduitPipe='C3'
!        if(TestCase.eq.'MA09') ConduitPipe='C2'
!        if(TestCase.eq.'MA11') ConduitPipe='C3'
        
        read(lunGid_dat,*)x1Conduit,x2Conduit,yConduit,zConduit,xPerforEnd,xPerforTrans
        read(lunGid_dat,*)ConduitCrossSection,ConduitDiameter
        
!        x1Conduit=0.36d0
!        x2Conduit=4.97d0  !5000.d0*0.3048d0  !5.0d0
!        yConduit=1.47d0  !1.37d0+0.03d0
!        zConduit=0.70d0 !0.d0   !0.75d0   !Bottom of the conduit
!        xPerforEnd=3.6d0
!        ConduitCrossSection='circular'   !circular/rectangular
!        ConduitDiameter=0.0155d0    !0.047d0    !12.d0*0.3048d0
        ConduitRectangularWidth=3.0d0
        ConduitRectangularTop=100.d0
        
        !Correction for C2 pipe
!        if(ConduitPipe.eq.'C2') x1Conduit=0.40d0
!        if(ConduitPipe.eq.'C2') x2Conduit=5.06d0
!        if(ConduitPipe.eq.'C2') yConduit=1.64   !!1.64d0
!        if(ConduitPipe.eq.'C2') xPerforEnd=2.1d0
!        if(ConduitPipe.eq.'C2') xPerforTrans=2.5d0
!        if(ConduitPipe.eq.'C2') ConduitDiameter=0.042d0     !0.047d0
        
        !!Correction for C1 pipe
        !if(ConduitPipe.eq.'C1') yConduit=1.90d0
        
        !Simulation time
        read(lunGid_dat,*)TimeStart, TimeEnd, TimeStep
        
!        TimeStart=0.d0*60d0
!        TimeEnd=2.d0*60.d0*60d0
!        TimeStep=2.0d0*60.d0
        
        
        !TimeEnd=TimeStart
 !       if(TestCase(1:2).eq.'MA') TimeEnd=TimeStart
 !       if(TestCase.eq.'MA07'.OR.TestCase.eq.'MA09'.OR.TestCase.eq.'MA11') TimeStep=1.d+20
 !       if(TestCase.eq.'MA07'.OR.TestCase.eq.'MA09'.OR.TestCase.eq.'MA11') TimeEnd=1*TimeStep
!TimeStep=1.d+20
!TimeEnd=1*TimeStep
!TimeEnd=4.d0*60.d0*60.d0        
!TimeEnd=TimeStart+1*TimeStep
        TimeCurr=TimeStart
        dt3D=TimeStep
        dt1D=dt3D
        MinTimeStep=0.2d0*60.d0/128.d0  !TimeStep*4.d0**(-5)
        MaxTimeStep=TimeStep*2.d0**(+1)
        read(lunGid_dat,*)MinTimeStep, MaxTimeStep, nWriteResults
        !Maximum number of iterations
        maxiter3D=8
        maxiter3D_SS=2000
        maxiter1D=18
        maxiter1D_SS=1000
        MaxIterKFM=12
        MinIterKFM=0 !1
        CorrectMaxIter='no'
!        nWriteResults=1 !nint(60.d0/TimeStep)        !Write results every nWriteResults time step
        resultsIter3D=100000    !write current results for specific iteration
        resultsIter1D=100000    !write current results for specific iteration
        !Convergence criterium for nonlinear solvers
        epsMatrix3D=1.d-5
        epsConduit1D=1.d-5
        epsNonLinKFM=min(epsMatrix3D,epsConduit1D)!*1.d-1
        !Implicit and explicit under-relaxation factors
        IUR3D=1.0d0
        EUR3D=0.4d0
        IUR1D=1.0d0
        EUR1D=0.6d0
        !if(ConduitPipe.eq.'C2') IUR3D=0.8d0
        if(ConduitPipe.eq.'C2') EUR3D=0.4d0
        if(ConduitPipe.eq.'C2') EUR1D=0.06d0
        if(ConduitPipe.eq.'C2') maxiter1D=32
        !Disable under-relaxation when close to true solution
        epsUR3D=1.d-16
        epsUR1D=1.d-16
        !Gradually introducing flux load for 3D matrix
        FluxRelaxation3D=0.6d0
        epsFR3D=5.d-4
        cfFR3D=0.1d0    !2.0d0
        !Gradually introducing source load for 1D conduit
        SourceRelaxation1D=1.d0
        epsSR1D=1.d-4
        cfSR1D=1.5d0
        !Imposition of Diriclet b.c. - weak/strong
        DirichetBCImposition3D='weak'
        !DirichetBCImposition1D='weak'    !Only weak incorporated
        !Imposition of b.c.
        !BCImposition1D='weak'
        !Penalty parameter for incorporatation of Dirichlet b.c. (make sence for weakly imposition)
        BCPenalty3D=1.d0
        BCPenalty1D=1.d0
        !ExchangeSourceTerm integration parameter
        kMaxEx=3
        !Mass lumping - for both left- and right- hand-side
        MassLump3D=.false.
        MassLump1D=.false. !still missing
        !Upstream weighting
        UpStreamW_Ksat3D=.false.
        UpStreamW_Krel3D=.false.  !.true.
        !Sum(aF)=-aC; where F are neigbor CV coefficients (which are set to zero if it has possitive value) and C is CV under consideration
        OppositeSignStabilization3D='no' !Only spatial terms
        OppositeSignStabilization1D='no' !Only spatial terms-NOT READY
        !Symmetry on "x" axis - model 1/2 domain
        Symmetry3D='no'
        !Steady state or transient calculation: steady/transient
        SteadyOrTransient3D='transient'
        SteadyOrTransient1D='transient'
        !Correction factor for steady state solution; 1.d0/0.d0 - transient/steady
        if(SteadyOrTransient3D.eq.'transient') cfSS3D=1.d0
        if(MATRIX3D.AND.SteadyOrTransient3D.eq.'steady') then
            cfSS3D=0.d0
            TimeStep=1.d0
            dt3D=TimeStep
            TimeEnd=TimeStart+TimeStep
            maxiter3D=maxiter3D_SS
        endif
        if(SteadyOrTransient1D.eq.'transient') cfSS1D=1.d0
        if(CONDUIT1D.AND.SteadyOrTransient1D.eq.'steady') then
            cfSS1D=0.d0
            TimeStep=1.d0
            dt1D=TimeStep
            TimeEnd=TimeStart+TimeStep
            maxiter1D=maxiter1D_SS
        endif
        !Dirichlet b.c.
        if(DirichetBCImposition3D.eq.'weak')   StronglyImposedDirichetBC3D=.false.
        if(DirichetBCImposition3D.eq.'strong') StronglyImposedDirichetBC3D=.true.
        if(DirichetBCImposition1D.eq.'weak')   StronglyImposedDirichetBC1D=.false.
        if(DirichetBCImposition1D.eq.'strong') StronglyImposedDirichetBC1D=.true.
        
        !Discharge unit converter m3/s-->l/min (or m3/s-->CFS)
        DischargeUnitConvert=60000.d0    !35.3146667d0   !60000.d0
        !Head unit converter m-->ft or 1.0 for stay in meters
        HeadUnitConvert=1.d0    !3.2808399d0
        !Time unit converter s-->min
        TimeUnitConvert=1.d0/60.d0
        
        BasisFun='fup'
        if(BasisFun.eq.'fup') nOrder=1
        if(BasisFun.eq.'spline') nOrder=2    
        
    end subroutine
                 
    real (kind=8) function ExchangeCoeff(xp)
    !Exchange discharge coefficient between matrix and conduit.
    
        real(kind=8) xp

        ExchangeCoeff=0.0d0
        if(SteadyStateKFM.eq..true.) return
            
!            if(ConduitPipe.eq.'C3') then
!                !Fi=20mm
!                if(xp.lt.xPerforEnd) ExchangeCoeff=0.18d0    !0.13d0
!            elseif(ConduitPipe.eq.'C2') then
!                !Fi=50mm
!                if(xp.lt.xPerforEnd) ExchangeCoeff=0.23d0
!            endif
             if(xp.lt.xPerforEnd) ExchangeCoeff=Alfa_ex
              
    end function
  
!___________________________________________________________!
 
    subroutine SurfaceIntegralOverCylinder_ExchangeDischarge(FF,a,b,yp0,zp0,diameter,kmax,Integ)
    !This subroutine calculates integral of 3D function over surface of cylinder. 
    !Cylinder is transformed on 2D rectangle with coordinates "x" and "l" where &
    !"l" represents arch lenght on cross-section circle of cylinder for defined x.
    !Trapezoidal numerical integration is used. Pipe axis is along "x" direction.
    !int[grad(BFUN)*n]dS=int[d/dn(BFUN)*N]dxdl; n-unit normal vector (conduit outward), N-normal vector. 
    !See integration of vector field on parametrized surfaces for last sentence.
    !
    !FF - Function to be integrated is exchange term in pipe equation defined &
    !as directional derivative of basis function: FF=d/dn(BFUN)=nx*d/dx(BFUN)+ny*d/dy(BFUN)+nz*d/dz(BFUN) where
    !n=(nx*i+ny*j+nz*k) surface unit normal with: nx=0, ny=cos(fi), nz=sin(fi)
    !norder,xv,yv,zv,dx,dy,dz,mdx,mdy,mdz - Basis function (BFUN) parameters
    !a,b - integration boundaries in "x" direction.
    !diameter,yp0,zp0 - pipe diameter and coordinates of pipe axis
    !kmax - integration parameter - defines number of points in each direction
    !Integ - returnes calculated value of integral
        !
        real (kind=8), external:: FF
        real (kind=8) xv,yv,zv,dx,dy,dz
        real (kind=8) a,b,diameter,yp0,zp0
        real (kind=8) Integ
        integer (kind=4) norder,mdx,mdy,mdz,kmax
        !
        real (kind=8) hx,hy,xx,ll
        real (kind=8) c,d,radius,fi
        real (kind=8) sx,sy,f
        integer (kind=4) i,j,icnt
        integer (kind=4) k,nk
        logical (kind=4) ipar,jpar
        
        !Integration boundaries in "l" direction
        c=0.d0
        d=diameter*pi
        !Radius of circle
        radius=0.5d0*diameter
        !Distance between integration points in first step
        hx=(b-a)
        hy=(d-c)
        !Sum function 4 boundary values
        !sy=0.d0
        sy=FF(a,yp0+radius,zp0)
        sy=sy+FF(b,yp0+radius,zp0)
        sy=2.d0*sy  !Double points in transformation 
           
        
        icnt=4
        do k=1,kmax
            nk=2**k
            hx=(b-a)/real(nk)
            hy=(d-c)/real(nk)
            do i=0,nk
                if(mod(i,2).eq.0) then
                    ipar=.true.
                else
                    ipar=.false.
                endif
                ll=c+i*hy
                !Angle for transformation from polar to Cartesian coordinates.
                fi=ll/(diameter*pi)*360.d0
                !
                sx=0
                do j=0,nk
                    if(mod(j,2).eq.0) then
                        jpar=.true.
                    else
                        jpar=.false.
                    endif
                    xx=a+j*hx
                    if(ipar.and.jpar) cycle
                    !Function value
                    f= radius**2*cos(fi)*FF(xx,yp0+radius*cos(fi),zp0+radius*sin(fi)) &
                      +radius**2*sin(fi)*FF(xx,yp0+radius*cos(fi),zp0+radius*sin(fi))
                    icnt=icnt+1
                    if(j.eq.0.or.j.eq.nk) then
                        sx=sx+f
                    else
                        sx=sx+2*f
                    endif
                enddo
                if(i.eq.0.or.i.eq.nk) then
                    sy=sy+sx
                else
                    sy=sy+2*sx
                endif
            enddo
        enddo
        
        Integ=sy*hx*hy/4.d0
        
        !write(*,'(a,i12,f20.10)') 'Integral 2D',icnt,sy*hx*hy/4.    
    
    end subroutine   
       
    real (kind=8) function ExchangeCoeff_x_HeadDifference(xp,yp,zp)
    !Head difference between matrix and conduit multiplied with exchange coefficient.
    
        real(kind=8) xp,yp,zp

        ExchangeCoeff_x_HeadDifference=ExchangeCoeff(xp)*HeadDifference(xp,yp,zp)


    end function


   real (kind=8) function ExchangeCoeff_x_Advectiveflux_C_M_Conc(xp,yp,zp)
    !Advective exchange term written for conduit 1-D ADE system
	!between matrix and conduit if C_ex = Conc3D.
    
        real(kind=8) xp,yp,zp

        ExchangeCoeff_x_Advectiveflux_C_M_Conc=ExchangeCoeff(xp)*AdvectiveExchange_C_M_Conc(xp,yp,zp)


    end function

  real (kind=8) function ExchangeCoeff_x_Advectiveflux_C_M_BFUN (xp,yp,zp)
    !Advective exchange term written for conduit 1-D ADE system
	!between matrix and conduit if C_ex = Conc1D.
    


        ExchangeCoeff_x_Advectiveflux_C_M_Conc=ExchangeCoeff(xp)*AdvectiveExchange_C_M_BFUN(xp,yp,zp)


    end function

 
    real (kind=8) function ExchangeCoeff_x_Advectiveflux_M_C_Conc(xp,yp,zp)
    !Advective exchange term written for matrix 3-D ADE system
	!between matrix and conduit if C_ex = Conc1D.
    
        real(kind=8) xp,yp,zp

        ExchangeCoeff_x_Advectiveflux_M_C_Conc=ExchangeCoeff(xp)*AdvectiveExchange_M_C_Conc(xp,yp,zp)


    end function

  real (kind=8) function ExchangeCoeff_x_Advectiveflux_M_C_BFUN (xp,yp,zp)
    !Advective exchange term written for matrix 3-D ADE system
	!between matrix and conduit if C_ex = Conc3D.
    


        ExchangeCoeff_x_Advectiveflux_M_C_Conc=ExchangeCoeff(xp)*AdvectiveExchange_M_C_BFUN(xp,yp,zp)


    end function

 
 
 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 
 
 
    real (kind=8) function ExchangeAdvectiveflux_C_M_Conc(xcp1,xcp2,Interact)
    !Advective exchange flux written for conduit 1-D ADE system
	!between matrix and conduit if C_ex = Conc3D.
    
        real (kind=8) xcp1,xcp2
        logical Interact
        
        ExchangeAdvectiveflux_C_M_Conc = 0.d0
        if(MATRIX3D.eq..false..OR.CONDUIT1D.eq..false.) return
        if(Interact.eq..false.) return
        
        !!!***!!! 
        call SurfaceIntegralOverCylinder_ExchangeDischarge(ExchangeCoeff_x_Advectiveflux_C_M_Conc,xcp1,xcp2,yConduit,zConduit,ConduitDiameter,kMaxEx,ExchangeAdvectiveflux_C_M_Conc)
        
    end function    
 
real (kind=8) function ExchangeAdvectiveflux_C_M_BFUN(xcp1,xcp2,Interact)
    !Advective exchange flux written for conduit 1-D ADE system
	!between matrix and conduit if C_ex = Conc1D.
    
        real (kind=8) xcp1,xcp2
        logical Interact
        
        ExchangeAdvectiveflux_C_M_BFUN=0.d0
        if(MATRIX3D.eq..false..OR.CONDUIT1D.eq..false.) return
        if(Interact.eq..false.) return
        
        !!!***!!! 
        call SurfaceIntegralOverCylinder_ExchangeDischarge(ExchangeCoeff_x_Advectiveflux_C_M_BFUN,xcp1,xcp2,yConduit,zConduit,ConduitDiameter,kMaxEx,ExchangeAdvectiveflux_C_M_BFUN)
        
    end function    
 
 
    real (kind=8) function ExchangeAdvectiveflux_M_C_Conc(xcp1,xcp2,Interact)
    !Advective exchange flux written for matrix 3-D ADE system
	!between matrix and conduit if C_ex = Conc1D.
    
        real (kind=8) xcp1,xcp2
        logical Interact
        
        ExchangeAdvectiveflux_M_C_Conc = 0.d0
        if(MATRIX3D.eq..false..OR.CONDUIT1D.eq..false.) return
        if(Interact.eq..false.) return
        
        !!!***!!! 
        call SurfaceIntegralOverCylinder_ExchangeDischarge(ExchangeCoeff_x_Advectiveflux_M_C_Conc,xcp1,xcp2,yConduit,zConduit,ConduitDiameter,kMaxEx,ExchangeAdvectiveflux_M_C_Conc)
        
    end function    
 
real (kind=8) function ExchangeAdvectiveflux_M_C_BFUN(xcp1,xcp2,Interact)
    !Advective exchange flux written for matrix 3-D ADE system
	!between matrix and conduit if C_ex = Conc3D.
    
        real (kind=8) xcp1,xcp2
        logical Interact
        
        ExchangeAdvectiveflux_M_C_BFUN=0.d0
        if(MATRIX3D.eq..false..OR.CONDUIT1D.eq..false.) return
        if(Interact.eq..false.) return
        
        !!!***!!! 
        call SurfaceIntegralOverCylinder_ExchangeDischarge(ExchangeCoeff_x_Advectiveflux_M_C_BFUN,xcp1,xcp2,yConduit,zConduit,ConduitDiameter,kMaxEx,ExchangeAdvectiveflux_M_C_BFUN)
        
    end function    
 

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


 real (kind=8) function ExchangeSourceTerm(xcp1,xcp2,Interact)
    !Discharge between matrix and pipe - first order exchange coefficient
    
        real (kind=8) xcp1,xcp2
        logical Interact
        
        ExchangeSourceTerm=0.d0
        if(MATRIX3D.eq..false..OR.CONDUIT1D.eq..false.) return
        if(Interact.eq..false.) return
        
        !!!***!!! 
        call SurfaceIntegralOverCylinder_ExchangeDischarge(ExchangeCoeff_x_HeadDifference,xcp1,xcp2,yConduit,zConduit,ConduitDiameter,kMaxEx,ExchangeSourceTerm)

    end function   
 
!___________________________________________________________!
    


    END MODULE

!External functions
real (kind=8) function HeadDifference(xp,yp,zp)
    !Head difference between matrix and conduit.
    use m3D_CV_IGA_Matrix
    use m1D_CV_IGA_Conduit
    
        real(kind=8) xp,yp,zp

        HeadDifference=Hm3D(xp,yp,zp)-Hc1D(xp)


    end function
          
!External functions
real (kind=8) function AdvectiveExchange_C_M_BFUN(xp,yp,zp)
    !Head difference between matrix and conduit muliplied by conduit basis function
    !if C_ex = Conc1D -> hdiff < 0.0d0. Needed for conduit ADE system.
    
    use m3D_CV_IGA_Matrix
    use m1D_CV_IGA_Conduit
    use mGlobalData
	use BASISFUNCTION
    
    
		real(kind=8) xp,yp,zp,hdiff
        
        
        hdiff = (Hm3D(xp,yp,zp)-Hc1D(xp))
        if (hdiff.gt.0.0d0) hdiff = 0.0d0 


        AdvectiveExchange_C_M_BFUN=hdiff*BFUN(norder_ex,xvertex_ex,xp,dx_ex,0,dlx1_ex,dlx2_ex)


    end function
	
!External functions
real (kind=8) function AdvectiveExchange_C_M_Conc(xp,yp,zp)
    !Head difference between matrix and conduit muliplied by matrix concentration
    !if C_ex = Conc3D -> hdiff > 0.0d0. Needed for conduit ADE system.
    
    use m3D_CV_IGA_Matrix
    use m1D_CV_IGA_Conduit
	
    
		real(kind=8) xp,yp,zp,hdiff
        
        
        hdiff = (Hm3D(xp,yp,zp)-Hc1D(xp))
        if (hdiff.lt.0.0d0) hdiff = 0.0d0 
        AdvectiveExchange_C_M_Conc=hdiff*Conc3D(xp,yp,zp)


    end function	
    
  !External functions
real (kind=8) function AdvectiveExchange_M_C_BFUN(xp,yp,zp)
    !Head difference between matrix and conduit muliplied by matrix basis function
    !if C_ex = Conc3D -> hdiff < 0.0d0. Needed for matrix 3-D ADE system.
    
    use m3D_CV_IGA_Matrix
    use m1D_CV_IGA_Conduit
	use BASISFUNCTION
    
    
		real(kind=8) xp,yp,zp,hdiff
        
        
        hdiff = (Hm3D(xp,yp,zp)-Hc1D(xp))
        if (hdiff.gt.0.0d0) hdiff = 0.0d0 


        AdvectiveExchange_M_C_BFUN=hdiff*BFUN(norder_ex,xvertex_ex,xp,dx_ex,0,dlx1_ex,dlx2_ex)*BFUN(norder_ex,yvertex_ex,yp,dy_ex,0,dly1_ex,dly2_ex)*BFUN(norder_ex,zvertex_ex,zp,dz_ex,0,dlz1_ex,dlz2_ex)


    end function
	
!External functions
real (kind=8) function AdvectiveExchange_M_C_Conc(xp,yp,zp)
    !Head difference between matrix and conduit muliplied by conduit concentration
    !if C_ex = Conc1D -> hdiff > 0.0d0. Needed for matrix ADE system.
    
    use m3D_CV_IGA_Matrix
    use m1D_CV_IGA_Conduit
	
    
		real(kind=8) xp,yp,zp,hdiff
        
        
        hdiff = (Hm3D(xp,yp,zp)-Hc1D(xp))
        if (hdiff.lt.0.0d0) hdiff = 0.0d0 
        AdvectiveExchange_M_C_Conc=hdiff*Conc1D(xp)


    end function	  
